function makeHeatMapFromCalcium(data,clim1,clim2,sortQ, input)

%This is a modified version of Josh Meisel's script that makes heat maps
%out of calcium imaging data. Modified so that it will accept a calcium
%imaging data file directly.

%Here's an example of how it should look: makeHeatMapFromCalcium(totalRel_M1_nIs678_flicker_20141218,-50,200,'sort','single')

%"clim1" and "clim2" are the upper and lower bounds of the percent change
%you are showing on the heatmap.

%input data and assign order based on peak value
%1. get into simple matrix

if strcmp(input,'single') %this is to account for the fact that data appears as a [28x20] submatrix in the way the imaging analysis makes batch analyzed data. If you are manually concatenating several days of experiments, you need to bypass this by removing 'single' from the input argument.
calcium=data{1} %get into own simple matrix 
else
calcium=data    
end
%2. Make get max values for each row
MaxValue=max(calcium)
%sort the list and get the rank index (I)
[M,I]=sort(MaxValue)

%use a for loop to resort based on max value
dimensions=size(calcium)
calciumMatrixSize=dimensions(1,2)

if strcmp(sortQ, 'sort')

    disp('yes')
    
for i=1:calciumMatrixSize
    targetTrace=I(i);
    calciumReadyToPlot(:,i)=calcium(:,targetTrace);
end

else

calciumReadyToPlot=calcium

end

%now, transpose it.
calciumTranspose=transpose(calciumReadyToPlot) %transpose
calciumPlot=calciumTranspose*100 %to put into percentages



%format the graph:
colormap('jet');
clims = [clim1,clim2];

imagesc(calciumPlot,clims);
colorbar
%line('XData', [0 94], 'YData', [8.5 8.5], 'LineStyle', '-', ...
%   'LineWidth', .5, 'Color','k');
set(gca,'XTick',[1,293/20,2*293/20,3*293/20,4*293/20,5*293/20,6*293/20])
set(gca,'XTickLabel',{'0','1','2','3','4','5','6'})
set(gca,'YTickLabel',{})
set(gca, 'TickDir', 'out')

prettify;